<?php
    /**
    *
    * copyright (c) 2015-2021 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * Classe che consente l'invio di email tramite la funzione mail di php. Il suo costruttore
    * costruisce in automatico un header base che può essere modificato
    */

    class GeneratoreEmail {
        private $nomeMittente;
        private $emailMittente;
        private $intestazione;
        
        function __construct($nomeMittente, $emailMittente, $rispondiA="", $intestazione = "") {
            $this->nomeMittente  = $nomeMittente;
            $this->emailMittente = $emailMittente;
            if($rispondiA=="") {
            	$rispondiA = $emailMittente;
            }
            
            if($intestazione == "") {
                $this->intestazione = "MIME-Version: 1.0" . "\r\n";
                $this->intestazione .= "Content-type:text/html;charset=UTF-8" . "\r\n";
                $this->intestazione .= "From: {$this->nomeMittente} <{$this->emailMittente}>" . "\r\n";
                $this->intestazione .= "Reply-To: {$rispondiA}" . "\r\n";
            }
            else {
                $this->intestazione = $intestazione;
            }
        }
        
        function invia($email, $oggetto, $messaggio) {
            mail($email, $oggetto, $messaggio, $this->intestazione);
        }
        
        // getter & setter
        function getNomeMittente() {
            return $this->nomeMittente;
        }

        function getEmailMittente() {
            return $this->emailMittente;
        }

        function getIntestazione() {
            return $this->intestazione;
        }

        function setNomeMittente($nomeMittente): void {
            $this->nomeMittente = $nomeMittente;
        }

        function setEmailMittente($emailMittente): void {
            $this->emailMittente = $emailMittente;
        }

        function setIntestazione($intestazione): void {
            $this->intestazione = $intestazione;
        }
    }